/*! Kaleidoscope ksdiff.js
 * https://kaleidoscope.app  */
(function() {
	
	if (window.ksdiff) {
		console.warn('ksdiff.js window.ksdiff already defined, abort.');
		return;
	}
	
	/*
	 * ksdiff - send text to Kaleidoscope
	 *
	 * Simple usage example:
	 * > ksdiff('Hello World')
	 *
	 * HTML Element example:
	 * > ksdiff($0.outerHTML)
	 *
	 * Objects example:
	 * > var obj = { prop1: 'value1', prop2: 'value2'};
	 * > ksdiff(JSON.stringify(obj, null, 2))
	 */
	window.ksdiff = function(text) {
		var page = window.location.href + "KSDIFF";
		var dataObj = { 'text': text, "page": page };
		var ksdiffEvent = new CustomEvent('ksdiffEvent', { 'detail': dataObj });
		document.dispatchEvent(ksdiffEvent);
	}
	
})();
