#!/bin/sh 

echoerr() { echo "$@" 1>&2; }

git_executable_path() {
	# See where the system thinks git is
	GIT_DIR=`which git`
	GIT_DIR_EXIT_CODE=$?
	if [ $GIT_DIR_EXIT_CODE -eq 0 ]; then
		if [ $GIT_DIR -ef "/usr/bin/git" ]; then
			# if git is only installed at the standard location
			# it could be that developer tools are not installed
			# so check for selected developer tools
			XCODE_SELECT_PATH=`xcode-select -p 2>/dev/null`
			XCODE_SELECT_PATH_EXIT_CODE=$?
			# check the exit code
			if [ $XCODE_SELECT_PATH_EXIT_CODE -eq 0 ]; then
				#echo "Found Apple Developer Tools $XCODE_SELECT_PATH"
				GIT_DIR=`xcrun --find git`
			else
				echoerr "Apple Developer Tools not installed" 1>&2
				exit $XCODE_SELECT_PATH_EXIT_CODE
			fi
		fi
	else 
		# This should not happen on macOS Sequoia, Sonoma or Ventura
		# There is always the placeholder executable in /usr/bin/git
		echoerr "No git installed"
		exit $GIT_DIR_EXIT_CODE
	fi
}

git_executable_path
if [ "$GIT_DIR" > /dev/null ] ; then
	echo "$GIT_DIR"
fi
